<?= $this->include('layout/header_admin') ?>

<div class="container mt-4">
    <h3 class="mb-4 text-primary">👥 Manage Admin</h3>

    <!-- Flash Message -->
    <?php if (session()->getFlashdata('success')): ?>
        <div class="alert alert-success"><?= session()->getFlashdata('success') ?></div>
    <?php endif; ?>
    <?php if (session()->getFlashdata('error')): ?>
        <div class="alert alert-danger"><?= session()->getFlashdata('error') ?></div>
    <?php endif; ?>

    <div class="mb-3 text-end">
        <a href="<?= base_url('/auth/create') ?>" class="btn btn-success">
            ➕ Tambah Admin
        </a>
    </div>

    <div class="table-responsive">
        <table class="table table-bordered table-striped align-middle">
            <thead class="table-dark">
                <tr>
                    <th>#</th>
                    <th>Username</th>
                    <th>Email</th>
                    <th width="180">Aksi</th>
                </tr>
            </thead>
            <tbody>
                <?php if (empty($admins)): ?>
                    <tr>
                        <td colspan="4" class="text-center text-muted">Data admin belum tersedia</td>
                    </tr>
                <?php endif; ?>
                <?php foreach ($admins as $index => $a): ?>
                    <tr>
                        <td><?= $index + 1 ?></td>
                        <td><?= esc($a['username']) ?></td>
                        <td><?= esc($a['email']) ?></td>
                        <td>
                            <a href="<?= base_url('/auth/edit/' . $a['id']) ?>" class="btn btn-warning btn-sm">Edit</a>
                            <a href="<?= base_url('/auth/delete/' . $a['id']) ?>" class="btn btn-danger btn-sm" onclick="return confirm('Yakin hapus admin ini?')">Hapus</a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>

</div>

<?= $this->include('layout/footer_admin') ?>